set pagesize 40
set serveroutput on size 2500
SELECT sessionid,indice,posicion,substr(nombre,1,10) "nombre(10)",
       substr(atributo,1,65) "atributo(65)"
FROM FSQL_QUERY --WHERE SESSIONID=USERENV('SESSIONID') 
order by SESSIONID,indice;

SELECT substr(OBJECT_NAME,0,30),OWNER--COUNT(*)
FROM DBA_OBJECTS DO
WHERE OBJECT_TYPE IN ('TABLE') and --,'VIEW','SNAPSHOT') AND 
      (DO.OWNER='SCOTT' OR
       1=(SELECT COUNT(*) FROM DBA_TAB_PRIVS
          WHERE TABLE_NAME=OBJECT_NAME AND GRANTEE   IN ('SCOTT','PUBLIC') AND
                GRANTOR   =DO.OWNER    AND PRIVILEGE IN ('ALL','SELECT'))
      )
ORDER BY OBJECT_NAME;

SELECT * FROM (SELECT COUNT(*) FROM ALL_TABLES),(SELECT COUNT(*) FROM ALL_VIEWS),(SELECT COUNT(*) FROM ALL_SNAPSHOTS);
EXEC SYS.X;
SELECT COUNT(*) FROM ACCESSIBLE_TABLES;

select table_name,owner from all_tables order by table_name;

select count(*) from all_tables order by table_name;

SELECT substr(OBJECT_NAME,0,30),OWNER--COUNT(*)
FROM DBA_OBJECTS DO
WHERE OBJECT_TYPE IN ('TABLE') and --,'VIEW','SNAPSHOT') AND 
      (DO.OWNER='PPGG' OR
       1=(SELECT COUNT(*) FROM DBA_TAB_PRIVS
          WHERE TABLE_NAME=OBJECT_NAME AND GRANTEE   IN ('PPGG','PUBLIC') AND
                GRANTOR   =DO.OWNER)
      )
ORDER BY OBJECT_NAME;

select * from dba_tab_privs where table_name='FUZZY_COL_LIST';

------------------------------------------------------------------VISTA
create or replace view ALL_OBJECTS
    (OWNER, OBJECT_NAME, OBJECT_ID, OBJECT_TYPE,
     CREATED, LAST_DDL_TIME, TIMESTAMP, STATUS)
as
select u.name, o.name, o.obj#,
       decode(o.type, 0, 'NEXT OBJECT', 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                      4, 'VIEW', 5, 'SYNONYM', 6, 'SEQUENCE', 
                      7, 'PROCEDURE', 8, 'FUNCTION', 9, 'PACKAGE',
                      11, 'PACKAGE BODY', 12, 'TRIGGER', 'UNDEFINED'),
       o.ctime, o.mtime,
       to_char(o.stime, 'YYYY-MM-DD:HH24:MI:SS'),
       decode(o.status, 0, 'N/A', 1, 'VALID', 'INVALID')
from sys.obj$ o, sys.user$ u
where o.owner# = u.user#
  and o.linkname is null
  and o.type != 10
  and
  (
    o.owner# in (userenv('SCHEMAID'), 1 /* PUBLIC */)
    or
    (
      o.type != 11 /* EXECUTE priv does not let user see pkg body */
      and
      o.obj# in (select obj# from sys.objauth$
                 where grantee# in (select kzsrorol from x$kzsro)
                   and privilege# in (3 /* DELETE */,   6 /* INSERT */,
                                      7 /* LOCK */,     9 /* SELECT */,
                                      10 /* UPDATE */, 12 /* EXECUTE */))
    )
    or
    (
       o.type in (7, 8, 9) /* prc, fcn, pkg */
       and
       exists (select null from v$enabledprivs
	       where priv_number in (
	                              -144 /* EXECUTE ANY PROCEDURE */,
	                              -141 /* CREATE ANY PROCEDURE */
				    )
              )
    )
    or
    (
       o.type in (12) /* trigger */
       and
       exists (select null from v$enabledprivs
	       where priv_number in (
	                              -152 /* CREATE ANY TRIGGER */
				    )
              )
    )
    or
    (
       o.type = 11 /* pkg body */
       and
       exists (select null from v$enabledprivs
	       where priv_number =   -141 /* CREATE ANY PROCEDURE */
              )
    )
    or
    (
       o.type in (1, 2, 4, 5) /* index, table, view, synonym */
       and
       exists (select null from v$enabledprivs
               where priv_number in (-45 /* LOCK ANY TABLE */,
				     -47 /* SELECT ANY TABLE */,
				     -48 /* INSERT ANY TABLE */,
				     -49 /* UPDATE ANY TABLE */,
				     -50 /* DELETE ANY TABLE */)
               )
    )
    or
    ( o.type = 6 /* sequence */
      and
      exists (select null from v$enabledprivs
              where priv_number = -109 /* SELECT ANY SEQUENCE */)
    )
  )

-----------------------------------------------------------------
--SYS                            ACCESSIBLE_TABLES                
select u.name, o.name,
       decode(o.type, 2, 'TABLE', 4, 'VIEW')
from sys.user$ u, sys.obj$ o
where o.owner# = u.user#
  and o.linkname is null
  and o.type in (2, 4)
  and (o.owner# = uid
       or
       obj# in (select obj#
                from sys.objauth$
                where grantee# in (select kzsrorol from x$kzsro)
               )
      )
-------------------------------------------------
CREATE OR REPLACE PROCEDURE X IS
I INTEGER;
BEGIN
  SELECT COUNT(*) INTO I FROM ACCESSIBLE_TABLES where table_name='INCEXP';
  DBMS_OUTPUT.PUT_LINE('-->> '||I);
  SELECT COUNT(*) INTO I FROM ACCESSIBLE_TABLES;
  DBMS_OUTPUT.PUT_LINE('-->> '||I);
--  FOR N IN (SELECT TABLE_NAME FROM ACCESSIBLE_TABLES ORDER BY TABLE_NAME) LOOP
--  DBMS_OUTPUT.PUT_LINE(N.TABLE_NAME);
--  END LOOP;
END X;
/
GRANT EXECUTE ON X TO PUBLIC;
-------------------------------------------------
CREATE OR REPLACE PROCEDURE Y IS
I INTEGER;
BEGIN
  SELECT COUNT(*) INTO I FROM ACCESSIBLE_TABLES;
  DBMS_OUTPUT.PUT_LINE('-->> '||I);
END Y;
/
GRANT EXECUTE ON Y TO PUBLIC;
--------------------------------------------------

SET PAGESIZE 80
SELECT * FROM ACCESSIBLE_TABLES ORDER BY TABLE_NAME;

EXEC SYS.X

INCEXP
INCFIL
INCVID

-- Vista que contiene las tablas o vistas accesibles por el usuario
create or replace view ACCESSIBLE_TABLES
    (OWNER, OBJ#, TABLE_NAME, TABLE_TYPE) as
select u.name, o.obj#, o.name,
       decode(o.type, 2, 'TABLE', 4, 'VIEW')
from sys.user$ u, sys.obj$ o
where o.owner# = u.user#
  and o.linkname is null
  and o.type in (2, 4)
  and (o.owner# = uid
       or
       obj# in (select obj#
                from sys.objauth$
                where grantee# in (select kzsrorol from x$kzsro)
                      or grantee#=uid
               )
      );
drop public synonym ACCESSIBLE_TABLES;
create public synonym ACCESSIBLE_TABLES for ACCESSIBLE_TABLES;
grant select on ACCESSIBLE_TABLES to PUBLIC with grant option;

comment on table ACCESSIBLE_TABLES is 'Tables and Views accessible to the user';
comment on column ACCESSIBLE_TABLES.OWNER is 'Owner of the object';
comment on column ACCESSIBLE_TABLES.TABLE_NAME is 'Name of the object';
comment on column ACCESSIBLE_TABLES.TABLE_TYPE is 'Type of the object';
comment on column ACCESSIBLE_TABLES.OBJ# is 'ID number of the object';

CREATE OR REPLACE PROCEDURE X IS
I INTEGER;
BEGIN
  SELECT COUNT(*) INTO I FROM FSQL_QUERY;
  DBMS_OUTPUT.PUT_LINE('---> '||I);
END X;
/